#include <stdio.h>
#include <stdlib.h>

void displayMatrix(int **matrix, int rows, int cols) {
    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < cols; j++) {
            printf("%d ", matrix[i][j]);
        }
        printf("\n");
    }
}

int compar(const void *a, const void *b) {
    return (*(int *)a - *(int *)b);
}

int main() {
    int rows, cols, subRows, subCols;
    scanf("%d %d %d %d", &rows, &cols, &subRows, &subCols);

    int *inputArray = (int *)malloc(rows * cols * sizeof(int));
    for (int i = 0; i < rows * cols; i++) {
        scanf("%d", &inputArray[i]);
    }

    int **matrix = (int **)malloc(rows * sizeof(int *));
    for (int i = 0; i < rows; i++) {
        matrix[i] = (int *)malloc(cols * sizeof(int));
        for (int j = 0; j < cols; j++) {
            matrix[i][j] = inputArray[i * cols + j];
        }
    }

    int maxElement = matrix[0][0];
    int maxRowIndex = 0, maxColIndex = 0;
    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < cols; j++) {
            if (matrix[i][j] > maxElement) {
                maxElement = matrix[i][j];
                maxRowIndex = i;
                maxColIndex = j;
            }
        }
    }

    int temp = matrix[rows / 2][cols / 2];
    matrix[rows / 2][cols / 2] = maxElement;
    matrix[maxRowIndex][maxColIndex] = temp;

    for (int i = 0; i < rows; i++) {
        qsort(matrix[i], cols, sizeof(int), compar);
        int index = cols / 2;
        for (int j = 0; j < cols; j++) {
            matrix[i][j] = matrix[i][(j + index) % cols];
        }
    }

    int **sortedMatrix = (int **)malloc(rows * sizeof(int *));
    for (int i = 0; i < rows; i++) {
        sortedMatrix[i] = (int *)malloc(cols * sizeof(int));
        int index = cols / 2;
        for (int j = 0; j < cols; j++) {
            sortedMatrix[i][j] = matrix[i][(j + index) % cols];
        }
    }

    int ***submatrices = (int ***)malloc((rows - subRows + 1) * sizeof(int **));
    for (int i = 0; i < rows - subRows + 1; i++) {
        submatrices[i] = (int **)malloc((cols - subCols + 1) * sizeof(int *));
        for (int j = 0; j < cols - subCols + 1; j++) {
            submatrices[i][j] = (int *)malloc(subRows * subCols * sizeof(int));
            for (int k = 0; k < subRows; k++) {
                for (int l = 0; l < subCols; l++) {
                    submatrices[i][j][k * subCols + l] = sortedMatrix[i + k][j + l];
                }
            }
        }
    }

    int totalSum = 0;
    for (int i = 0; i < rows - subRows + 1; i++) {
        for (int j = 0; j < cols - subCols + 1; j++) {
            for (int k = 0; k < subRows * subCols; k++) {
                totalSum += submatrices[i][j][k];
            }
        }
    }

    printf("%d\n", totalSum);

    for (int i = 0; i < rows; i++) {
        free(matrix[i]);
        free(sortedMatrix[i]);
    }
    free(matrix);
    free(sortedMatrix);

    for (int i = 0; i < rows - subRows + 1; i++) {
        for (int j = 0; j < cols - subCols + 1; j++) {
            free(submatrices[i][j]);
        }
        free(submatrices[i]);
    }
    free(submatrices);

    free(inputArray);

    return 0;
}